/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.rcs.CommManager;
import com.ibm.hwmca.fw.rcs.PathQueueListener;
import com.ibm.hwmca.fw.rcs.RcsCallbackSegment;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.RcsObject;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathEvent;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.util.RcsModemControl;
import com.ibm.hwmca.fw.rcs.util.RcsTrace;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathManager
extends RcsObject
implements ShutdownListener {
    private static final long TIMEOUT = 10000L;
    private static PathManager instance;
    private boolean notToldToShutdown = true;
    protected List listeners = new ArrayList();
    private List queueHi = new LinkedList();
    private List queueLo = new LinkedList();
    protected boolean queueOnHold = false;
    protected Set activePaths = new HashSet();
    protected Set waitingPaths = new HashSet();
    protected Set readyPaths = new HashSet();
    protected Map paths = new HashMap();
    private Object threadLock = new Object();
    private Object dataLock = new Object();
    protected RcsLink activeLink = null;
    public static final int SDC_PRIMARY = 1;
    public static final int SDC_SECONDARY = 2;
    private int sdc = 1;
    private static boolean rsCall;
    int failedReturnCode = 0;

    private PathManager() {
        new Thread(){

            public void run() {
                this.setName("PathManager worker thread.");
                PathManager.this.startPathManager();
                PathManager.this.managePaths();
                PathManager.this.stopPathManager();
            }
        }.start();
    }

    public static synchronized PathManager getPathManager() {
        return instance;
    }

    private void startPathManager() {
        ShutdownManager.getShutdownManager().addShutdownListener(this);
        CommManager.getCommManager();
        RcsControl.init();
        boolean zConfig = false;
        try {
            zConfig = new File(BaseFileControl.getFilePath("rcsconfig") + "/rcsModemControl.xml").exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (zConfig) {
            RcsModemControl.getInstance();
        } else {
            RcsCallbackSegment.run();
        }
    }

    private void stopPathManager() {
        RcsControl.quit();
        boolean zConfig = false;
        try {
            zConfig = new File(BaseFileControl.getFilePath("rcsconfig") + "/rcsModemControl.xml").exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (zConfig) {
            // empty if block
        }
    }

    public void shutdownStarting(ShutdownRequest request, long delay) {
        this.ttrace("<-> shutdownStarting( " + request + ", " + delay + " )");
        this.notToldToShutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] addPathQueueListener(PathQueueListener listener) throws NullPointerException {
        this.ttrace("--> addPathQueueListener(" + listener + ")");
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        List[] queues = null;
        Object object = this.dataLock;
        synchronized (object) {
            this.listeners.add(listener);
            queues = new List[]{this.getActivePaths(), this.getQueuedPaths()};
        }
        this.ttrace("<-- addPathQueueListener() [" + queues + "]");
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathQueueListener(PathQueueListener listener) {
        this.ttrace("--> removePathQueueListener(" + listener + ")");
        Object object = this.dataLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        this.ttrace("<-- removePathQueueListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActivePaths() {
        this.ttrace("--> getActivePaths()");
        ArrayList paths = new ArrayList();
        Object object = this.dataLock;
        synchronized (object) {
            paths.addAll(this.activePaths);
            paths.addAll(this.waitingPaths);
        }
        this.ttrace("<-- getActivePaths() [" + paths + "]");
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueuedPaths() {
        this.ttrace("--> getQueuedPaths()");
        ArrayList queue = new ArrayList();
        Object object = this.dataLock;
        synchronized (object) {
            queue.addAll(this.readyPaths);
            queue.addAll(this.queueHi);
            queue.addAll(this.queueLo);
        }
        this.ttrace("<-- getQueuedPaths() [" + queue + "]");
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueOnHold(boolean value) {
        this.ttrace("--> setQueueOnHold(" + value + ")");
        Object object = this.dataLock;
        synchronized (object) {
            if (this.queueOnHold != value) {
                this.queueOnHold = value;
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).queueStateChanged(value);
                }
            }
        }
        this.ttrace("<-- setQueueOnHold()");
    }

    public boolean isQueueOnHold() {
        this.ttrace("<-> isQueueOnHold() [" + this.queueOnHold + "]");
        return this.queueOnHold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void managePaths() {
        Object pathId;
        Iterator i;
        this.ttrace("--> managePaths()");
        Object object = this.threadLock;
        // MONITORENTER : object
        while (this.notToldToShutdown) {
            try {
                Object pathId2;
                if (!this.waitingPaths.isEmpty()) {
                    this.ftrace("  ] paths are waiting for a link to open");
                    if (this.activeLink != null && this.activeLink.isActive()) {
                        this.ftrace("  ] active link to utilize");
                        Object object2 = this.dataLock;
                        // MONITORENTER : object2
                        i = this.waitingPaths.iterator();
                        while (i.hasNext()) {
                            pathId = (PathIdentifier)i.next();
                            RcsPath path = (RcsPath)this.paths.get(pathId);
                            if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) continue;
                            i.remove();
                            this.activePaths.add(pathId);
                            path.sendEvent(PathEvent.OPENED);
                        }
                        // MONITOREXIT : object2
                    } else {
                        this.activeLink = null;
                        pathId2 = null;
                        RcsPath path = null;
                        pathId = this.dataLock;
                        // MONITORENTER : pathId
                        Iterator i2 = this.waitingPaths.iterator();
                        if (i2.hasNext()) {
                            pathId2 = (PathIdentifier)i2.next();
                            path = (RcsPath)this.paths.get(pathId2);
                        }
                        // MONITOREXIT : pathId
                        if (pathId2 != null) {
                            this.ftrace("  ] no active link but there is a path waiting");
                            List links = path.getSupportedLinkTypes();
                            boolean nothingWasConfigured = true;
                            if (links != null) {
                                Iterator li = links.iterator();
                                while (li.hasNext()) {
                                    Class linkClass = (Class)li.next();
                                    this.ftrace("  ] attempting to use " + linkClass);
                                    try {
                                        Method method = linkClass.getMethod("getInstance", null);
                                        RcsLink link = (RcsLink)method.invoke(null, null);
                                        link.setPath(path);
                                        if (!link.isConfigured()) continue;
                                        nothingWasConfigured = false;
                                        if (!link.activate()) continue;
                                        this.activeLink = link;
                                        this.ftrace("  ] " + linkClass + " was successfully activated");
                                        Object object3 = this.dataLock;
                                        // MONITORENTER : object3
                                        if (this.waitingPaths.remove(pathId2)) {
                                            this.activePaths.add(pathId2);
                                        }
                                        // MONITOREXIT : object3
                                        path.setRcsLink(link);
                                        path.sendEvent(PathEvent.OPENED);
                                        break;
                                    }
                                    catch (InvocationTargetException invokeException) {
                                        Throwable e = invokeException.getCause();
                                        if (e == null) continue;
                                        if (e instanceof LinkAlreadyActiveException) {
                                            this.ftrace("Warning: LinkAlreadyActiveException");
                                            continue;
                                        }
                                        if (e instanceof LinkFailedException) {
                                            this.failedReturnCode = ((LinkFailedException)e).getReturnCode();
                                            this.ftrace("Warning: LinkFailedException");
                                            this.logInfoError(e);
                                            continue;
                                        }
                                        if (e instanceof LinkNotConfiguredException) {
                                            this.ftrace("Warning: LinkNotConfiguredException");
                                            this.logInfoError(e);
                                            continue;
                                        }
                                        this.ftrace("Error: Unexpected Exception (" + e + ")");
                                        this.logInfoError(new HException(e));
                                    }
                                    catch (Exception e) {
                                        this.ttrace("Error: Unexpected Exception (" + e + ")");
                                        this.logInfoError(e);
                                    }
                                }
                                if (this.activeLink == null) {
                                    this.cancelPath((PathIdentifier)pathId2, PathCancelReason.LINK);
                                    if (nothingWasConfigured) {
                                        this.ttrace("Warning: no links were configured");
                                        this.logInfoError("HMC was asked to call home but nothing has been configured.");
                                    } else {
                                        this.ftrace("Error: all links failed to connect");
                                        this.logInfoError("All configured callhome options have failed!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                if (this.activeLink != null && this.activeLink.isActive()) {
                    this.ftrace("  ] there is an active link");
                    if (!this.queueOnHold) {
                        pathId2 = this.dataLock;
                        // MONITORENTER : pathId2
                        i = new ArrayList(this.queueHi).iterator();
                        while (this.waitingPaths.size() + this.readyPaths.size() + this.activePaths.size() < this.activeLink.getMaxOpenPaths() && i.hasNext()) {
                            this.ftrace("  ] queued high priority paths");
                            pathId = (PathIdentifier)i.next();
                            RcsPath path = (RcsPath)this.paths.get(pathId);
                            if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) continue;
                            this.queueHi.remove(pathId);
                            this.ftrace("adding " + pathId + " to readyPaths");
                            this.readyPaths.add(pathId);
                            path.sendEvent(PathEvent.READY);
                        }
                        // MONITOREXIT : pathId2
                        pathId2 = this.dataLock;
                        // MONITORENTER : pathId2
                        if (!this.queueLo.isEmpty()) {
                            this.ftrace("  ] queued low priority paths");
                            this.ftrace("waitingPaths.size() = " + this.waitingPaths.size());
                            this.ftrace("readyPaths.size() = " + this.readyPaths.size());
                            this.ftrace("activePaths.size() = " + this.activePaths.size());
                            i = new ArrayList(this.queueLo).iterator();
                            while (this.waitingPaths.size() + this.readyPaths.size() + this.activePaths.size() < this.activeLink.getMaxOpenPaths() && i.hasNext()) {
                                pathId = (PathIdentifier)i.next();
                                RcsPath path = (RcsPath)this.paths.get(pathId);
                                this.ftrace("checking " + pathId + " to see if it can utilize this connection");
                                if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) break;
                                this.queueLo.remove(pathId);
                                this.ftrace("adding " + pathId + " to readyPaths");
                                this.readyPaths.add(pathId);
                                path.sendEvent(PathEvent.READY);
                            }
                        }
                        // MONITOREXIT : pathId2
                    }
                    if (this.activePaths.isEmpty() && this.readyPaths.isEmpty()) {
                        this.ftrace("  ] nothing active, deactivating link");
                        this.activeLink.deactivate();
                        this.activeLink = null;
                    } else {
                        this.ftrace("  ] currently active paths (" + this.activePaths + " | " + this.readyPaths + ")");
                    }
                }
                if (this.activeLink == null || !this.activeLink.isActive()) {
                    this.activeLink = null;
                    pathId2 = this.dataLock;
                    // MONITORENTER : pathId2
                    if (!this.activePaths.isEmpty()) {
                        this.ftrace("  ] active paths is not empty (link was shutdown unexpectedly)");
                        i = new HashSet(this.activePaths).iterator();
                        while (i.hasNext()) {
                            pathId = (PathIdentifier)i.next();
                            this.cancelPath((PathIdentifier)pathId, PathCancelReason.LINK);
                        }
                    }
                    // MONITOREXIT : pathId2
                    pathId2 = this.dataLock;
                    // MONITORENTER : pathId2
                    if (this.readyPaths.isEmpty() && this.waitingPaths.isEmpty() && !this.queueOnHold) {
                        PathIdentifier pathId3;
                        if (!this.queueHi.isEmpty()) {
                            pathId3 = (PathIdentifier)this.queueHi.remove(0);
                            this.ftrace("adding " + pathId3 + " to readyPaths");
                            this.readyPaths.add(pathId3);
                            ((RcsPath)this.paths.get(pathId3)).sendEvent(PathEvent.READY);
                        } else if (!this.queueLo.isEmpty()) {
                            pathId3 = (PathIdentifier)this.queueLo.remove(0);
                            this.ftrace("adding " + pathId3 + " to readyPaths");
                            this.readyPaths.add(pathId3);
                            ((RcsPath)this.paths.get(pathId3)).sendEvent(PathEvent.READY);
                        }
                    }
                    // MONITOREXIT : pathId2
                }
                try {
                    this.threadLock.wait(10000L);
                }
                catch (Exception e) {
                    this.ftrace("Timeout");
                }
            }
            catch (Exception e) {
                this.ftrace("Uncaught Exception: " + e);
                this.logInfoError(e);
            }
        }
        ArrayList allPaths = new ArrayList();
        allPaths.addAll(this.queueHi);
        allPaths.addAll(this.queueLo);
        allPaths.addAll(this.readyPaths);
        allPaths.addAll(this.waitingPaths);
        allPaths.addAll(this.activePaths);
        i = allPaths.iterator();
        while (true) {
            if (!i.hasNext()) {
                // MONITOREXIT : object
                this.ftrace("<-- managePaths()");
                return;
            }
            pathId = (PathIdentifier)i.next();
            this.cancelPath((PathIdentifier)pathId, PathCancelReason.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(RcsPath path) throws NullPointerException {
        this.ttrace("--> addPath( " + path + " )");
        if (path == null) {
            throw new NullPointerException();
        }
        Object object = this.dataLock;
        synchronized (object) {
            PathIdentifier pathId = path.getPathIdentifier();
            int position = this.readyPaths.size();
            this.paths.put(pathId, path);
            if (path.getPriority() == PathPriority.LOW) {
                this.queueLo.add(pathId);
                position += this.queueHi.size() + this.queueLo.indexOf(pathId);
            } else if (path.getPriority() == PathPriority.HIGH) {
                this.queueHi.add(pathId);
                position += this.queueHi.indexOf(pathId);
            }
            Iterator listenIt = this.listeners.iterator();
            while (listenIt.hasNext()) {
                ((PathQueueListener)listenIt.next()).addedToWaiting(pathId, position);
            }
        }
        this.ttrace("<-- addPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPath(PathIdentifier pathId, PathCancelReason reason) throws IllegalArgumentException {
        this.ttrace("--> cancelPath( " + pathId + ", " + reason + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                path.sendEvent(PathEvent.CANCELLED, reason);
                try {
                    this.closePath(pathId);
                }
                catch (IllegalArgumentException e) {
                    this.ftrace("Swallowing IllegalArgumentException since path has already been closed");
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError("Exception occurred while trying to cancel a path.", e);
            }
        }
        this.ttrace("<-- cancelPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPath(PathIdentifier pathId) throws IllegalArgumentException {
        this.ttrace("--> openPath( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                if (!this.readyPaths.contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                this.readyPaths.remove(pathId);
                this.waitingPaths.add(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).moveFromWaitingToActive(pathId);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError("Exception occurred while trying to open a path.", e);
            }
        }
        this.ttrace("<-- openPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePath(PathIdentifier pathId) throws IllegalArgumentException {
        this.ttrace("--> closePath( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                boolean wasActive = false;
                if (!this.paths.keySet().contains(pathId)) {
                    return;
                }
                if (this.activePaths.remove(pathId)) {
                    wasActive = true;
                }
                if (this.waitingPaths.remove(pathId)) {
                    wasActive = true;
                }
                this.readyPaths.remove(pathId);
                this.queueHi.remove(pathId);
                this.queueLo.remove(pathId);
                this.paths.remove(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    if (wasActive) {
                        ((PathQueueListener)listenIt.next()).removedFromActive(pathId);
                        continue;
                    }
                    ((PathQueueListener)listenIt.next()).removedFromWaiting(pathId);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError("Exception occurred while trying to close a path.", e);
            }
        }
        this.ttrace("<-- closePath()");
    }

    public void setPriority(PathIdentifier pathId, PathPriority priority) throws IllegalArgumentException {
        this.ttrace("--> setPriority( " + pathId + ", " + priority + " )");
        this.ttrace("DEPRECATED");
        this.ttrace("<-- setPriority()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathNext(PathIdentifier pathId) throws IllegalArgumentException {
        this.ttrace("--> setPathNext( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                if (this.queueLo.remove(pathId)) {
                    this.queueHi.add(0, pathId);
                    int position = this.readyPaths.size();
                    Iterator listenIt = this.listeners.iterator();
                    while (listenIt.hasNext()) {
                        ((PathQueueListener)listenIt.next()).reorderInWaiting(pathId, position);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError(e);
            }
        }
        this.ttrace("<-- setPathNext()");
    }

    public boolean failLink() {
        if (this.activeLink == null) {
            this.ttrace("<-> failLink() [false]");
            return false;
        }
        boolean fail = this.activeLink.fail();
        this.ttrace("<-> failLink() [" + fail + "]");
        return fail;
    }

    public InetAddress getLinkAddress() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        InetAddress ip = null;
        this.ttrace("<-> getLinkAddress() [" + ip + "]");
        return ip;
    }

    public boolean isHighPerformanceLink() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        boolean hpl = this.activeLink.isHighPerformanceLink();
        this.ttrace("<-> isHighPerformanceLink() [" + hpl + "]");
        return hpl;
    }

    public void setSdc(int sdc) {
        this.ttrace("<-> setSdc( " + sdc + " )");
        this.sdc = sdc;
    }

    public int getSdc() {
        this.ttrace("<-> getSdc() [" + this.sdc + "]");
        return this.sdc;
    }

    public boolean isRemoteServiceCall() {
        return false;
    }

    public void setRemoteServiceCall(boolean b) {
        rsCall = b;
    }

    public int getReturnCode() {
        return this.failedReturnCode;
    }

    static {
        try {
            instance = new PathManager();
        }
        catch (Exception e) {
            RcsTrace.logInfoError("PathManager.static Exception", e);
        }
        rsCall = false;
    }

    public static class Init
    implements Runnable {
        public void run() {
            RcsTrace.ttrace("PathManager.Init --> run()");
            PathManager.getPathManager();
            RcsTrace.ttrace("PathManager.Init <-- run()");
        }
    }
}

